//

var pin_list = [];
var ScriptName = "Quick Recorder Pin.js";

if (! String.prototype.trim ) {
  String.prototype.trim = function() {
  	return this.replace(/^\s+|\s+$/g, "");
  }
}

function main(doc) {
  var obj = doc.root();
  
  pin_list.length = 0;
  correctPinnedObject( obj );
  
  //print( "pin_list:" + pin_list );
  
  currentTake = doc.currentTake();
  
  for (var i = 0;i < pin_list.length;i++) {
    var pin = pin_list[ i ];
    var tag = tagForScriptName( pin, ScriptName );
    
    //print( "tag"+i+":"+tag );
    recordForPinnedObject( pin, doc.animPosition(), tag );
  }
}

var currentTake;

function recordForPinnedObject( obj, time, tag ) {
  if (tag.getParameter("recursive") && obj.childCount() > 0) {
    var childCount = obj.childCount();
    for (var i = 0;i < childCount;i++) {
      var child = obj.childAtIndex( i );
      recordForPinnedObject( child, time, tag );
    }
  }
  
  var recPos = tag.getParameter("record position");
  var recRot = tag.getParameter("record rotation");
  var recScale = tag.getParameter("record scale");
  
  var recName = tag.getParameter("record names");
  var recNames = recName.split(/[, ]/);
  
  obj.recordParametersForUndo();
  
  if (recPos) {
    setKeyForObjWithParameterName( obj, "position", time, tag );
    
  }
  if (recRot) {
    setKeyForObjWithParameterName( obj, "rotation", time, tag );
  }
  if (recScale) {
    setKeyForObjWithParameterName( obj, "scale", time, tag );
  }
  if (recNames.length > 0) {
    for (var i = 0;i < recNames.length;i++) {
      if (recNames[i] != "") setKeyForObjWithParameterName( obj, recNames[i].trim(), time, tag );
    }
  }
}

function setKeyForObjWithParameterName( obj, name, time, tag ) {
    var p = obj.parameterWithName(name);
    if (!p) return;
    var val = obj.getParameter(name);
    var values;
    switch( p.type() ) {
      case INT_PARAMETER:
      case FLOAT_PARAMETER:
      case BOOL_PARAMETER:
        values = [ val ];
        break;
      case VEC2D_PARAMETER:
        values = [ val.x, val.y ];
        break;
      case VEC3D_PARAMETER:
        values = [ val.x, val.y, val.z ];
        break;
      case VEC4D_PARAMETER:
        values = [ val.x, val.y, val.z, val.w ];
        break;
      default:
        return;
    }
    var takeNode = p.takeNodeWithName( currentTake.name );
    if (!takeNode) takeNode = p.addTakeNode( currentTake.name );
    
    for (var i = 0;i < values.length;i++) {
      var keyIndex = -1;
      var keySet = -1;
      var curve = takeNode.fCurveAtIndex(i);
      
      var key_prev = null;
      var key_after = null;
      
      var kCount = curve.keyCount();
      for (var j = 0;j < kCount;j++) {
        var key = curve.keyAtIndex(j);
        
        if (key.time == time) {
          keyIndex = j;
          keySet = j;
        } else if (key.time < time) {
          if (key_prev == null) {
            key_prev = key;
          } else if (key_prev.time < time) {
            key_prev = key;
          }
        } else if (key.time > time) {
          if (key_after == null) {
            key_after = key;
          } else if (key_after.time > time ) {
            key_after = key;
          }
          keyIndex = j;
          break;
        }
      }
      
      //print(keySet + ':' + keyIndex + ':' + kCount);
      
      key = new FCurveKey();
      
      //key.selected = false;
      key.time = time;
      key.value = values[i];
      
      var type = tag.getParameter("curve type");
      
      //print( "type:"+type+", prev:"+key_prev+", after:"+key_after );
      switch( parseInt(type) ) {
        case 0:
          key.left_type = SOFT_INTERPOL;
          key.left_time = 0;
          key.right_type = SOFT_INTERPOL;
          key.right_time = 0;
          break;
        case 1:
          key.left_type = SPLINE_INTERPOL;
          key.left_time = ( key_prev )? (key.time - key_prev.time) * -0.25 : 0;
          key.left_value = 0;
          key.right_type = SPLINE_INTERPOL;
          key.right_time = ( key_after )? (key_after.time - key.time) * 0.25 : 0;
          key.right_value = 0;
          break;
        case 2:
          key.left_type = FLAT_INTERPOL;
          key.left_time = 0;
          key.right_type = FLAT_INTERPOL;
          key.right_time = 0;
          break;
        case 3:
          key.left_type = LINEAR_INTERPOL;
          key.left_time = 0;
          key.right_type = LINEAR_INTERPOL;
          key.right_time = 0;
          break;
      }
      if (keySet > 0) {
        curve.setKeyAtIndex( key, keySet );
      } else {
        if (keyIndex > 0) {
          curve.insertKeyAtIndex( key, keyIndex );
        } else {
          curve.addKey( key );
        }
      }
      curve.update();
    }
}

function correctPinnedObject( obj ) {
  var childCount = obj.childCount();
  for (var i = 0;i < childCount;i++) {
    var child = obj.childAtIndex( i );
    
    correctPinnedObject( child );
  }
  
  var tag = tagForScriptName( obj, ScriptName);
  
  if (tag != null) {
    pin_list.push( obj );
  }
}

function tagForScriptName(obj, scriptName) {
	var tagCount = obj.tagCount();
	var resultTag = null;
	for (var i = 0;i < tagCount;i++) {
		var tag = obj.tagAtIndex(i);
		if (tag.getParameter("scriptName").match(scriptName) && tag.getParameter("tagOn")) {
			resultTag = tag;
		}
	}
	return resultTag;
}
